/* VICSES-23 Show portlet prefs Javascript script */

const GroupServiceUtil = Packages.com.liferay.portal.service.GroupServiceUtil();
const PortletBeanLocatorUtil = Packages.com.liferay.portal.kernel.bean.PortletBeanLocatorUtil();
const UserLocalServiceUtil = Packages.com.liferay.portal.service.UserLocalServiceUtil();
const LayoutServiceUtil = Packages.com.liferay.portal.service.LayoutServiceUtil();
const LayoutLocalServiceUtil = Packages.com.liferay.portal.service.LayoutLocalServiceUtil();
const PortletPreferencesLocalServiceUtil = com.liferay.portal.service.PortletPreferencesLocalServiceUtil();
const PortalUtil = Packages.com.liferay.portal.util.PortalUtil();
const GroupConstants = Packages.com.liferay.portal.model.GroupConstants();
const LayoutConstants = Packages.com.liferay.portal.model.LayoutConstants();
const PortletKeys = Packages.com.liferay.portal.util.PortletKeys();
const DLAppServiceUtil = Packages.com.liferay.portlet.documentlibrary.service.DLAppServiceUtil();
const DLFileEntryLocalServiceUtil = com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil();
const DLFolderLocalServiceUtil = com.liferay.portlet.documentlibrary.service.DLFolderLocalServiceUtil();

// hub staging
// var groupId = 127828;

// hub live site
var groupId = 381376;

var privateLayout = true;
var friendlyURL = "/home";
var layout = LayoutLocalServiceUtil.getFriendlyURLLayout(groupId, privateLayout, friendlyURL);
var layoutTypePortlet = layout.getLayoutType();
var portletIds = layoutTypePortlet.getPortletIds().toArray();

var ownerId = PortletKeys.PREFS_OWNER_ID_DEFAULT;
var ownerType = PortletKeys.PREFS_OWNER_TYPE_LAYOUT;

for (var pid in portletIds) {
  var portletId = portletIds[pid];
  var portletPrefs = PortletPreferencesLocalServiceUtil.getPreferences(layout.getCompanyId(), ownerId, ownerType, layout.getPlid(), portletId );

  out.println("=== portlet " + portletId + " ===");
  out.println(layout.getCompanyId() + " " + ownerId + " " + ownerType + " " + layout.getPlid() + " " + portletId);
  
  var mykeys = portletPrefs.getMap().keySet().toArray();
  for (var n in mykeys) {
    var key = mykeys[n];
    out.println(key + "|" + portletPrefs.getValue(key, ""));
  }
  out.println("===");  
  out.println("");    
  
}